<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Morry Ultra Modern Hospital - Email Sender Dashboard</title>
    <script src="https://cdn.jsdelivr.net/npm/@tailwindcss/browser@4"></script>
    <style>
        /* Custom styles for professional appearance */
        .gold-accent {
            background: linear-gradient(90deg, #d4af36 0%, #f4e4bc 100%);
        }
        
        .form-input:focus {
            border-color: #d4af36;
            box-shadow: 0 0 0 3px rgba(212, 175, 54, 0.1);
        }
        
        .preview-container {
            max-height: 600px;
            overflow-y: auto;
        }
        
        .preview-container::-webkit-scrollbar {
            width: 8px;
        }
        
        .preview-container::-webkit-scrollbar-track {
            background: #f1f1f1;
        }
        
        .preview-container::-webkit-scrollbar-thumb {
            background: #888;
            border-radius: 4px;
        }
        
        .preview-container::-webkit-scrollbar-thumb:hover {
            background: #555;
        }
        
        /* Email template responsive styles */
        @media (max-width: 600px) {
            /* Email template mobile styles */
            .email-container {
                width: 100% !important;
                margin: 0 !important;
            }
            
            .header-padding {
                padding: 30px 20px !important;
            }
            
            .header-title {
                font-size: 24px !important;
                letter-spacing: 6px !important;
            }
            
            .header-subtitle {
                font-size: 9px !important;
                letter-spacing: 2px !important;
            }
            
            .hero-padding {
                padding: 40px 25px !important;
            }
            
            .hero-title {
                font-size: 20px !important;
            }
            
            .content-padding {
                padding: 30px 20px !important;
            }
            
            .feature-box {
                display: block !important;
                width: 100% !important;
                padding: 0 0 20px 0 !important;
            }
            
            .feature-box-content {
                padding: 20px !important;
            }
            
            .feature-box-content h3 {
                font-size: 12px !important;
            }
            
            .feature-box-content p {
                font-size: 11px !important;
            }
            
            .cta-button {
                padding: 15px 35px !important;
                font-size: 11px !important;
                letter-spacing: 1px !important;
            }
            
            .contact-item {
                display: block !important;
                border: none !important;
                padding: 10px !important;
                text-align: center !important;
            }
            
            .contact-item p {
                font-size: 12px !important;
            }
            
            /* Stack table columns on mobile */
            table[role="presentation"] td {
                display: block !important;
                width: 100% !important;
                text-align: center !important;
            }
            
            /* Adjust font sizes for mobile */
            p {
                font-size: 13px !important;
                line-height: 1.6 !important;
            }
        }
        
        @media (max-width: 768px) {
            .form-grid {
                grid-template-columns: 1fr !important;
            }
            
            .preview-container {
                max-height: 400px;
            }
            
            /* Mobile header adjustments */
            header .container > div {
                flex-direction: column;
                text-align: center;
            }
            
            header .text-right {
                text-align: center !important;
                margin-top: 1rem;
            }
            
            /* Mobile form adjustments */
            .bg-white.rounded-lg.shadow-lg {
                padding: 1.5rem !important;
            }
            
            /* Stack grid columns on mobile */
            .grid.grid-cols-2 {
                grid-template-columns: 1fr !important;
            }
            
            /* Mobile button layout */
            .flex.justify-end.items-center {
                flex-direction: column;
                align-items: stretch !important;
            }
            
            .flex.justify-end.items-center > button {
                width: 100%;
                margin: 0.5rem 0 !important;
            }
            
            /* Mobile footer */
            footer .flex.justify-between {
                flex-direction: column;
                text-align: center;
            }
            
            footer .text-right {
                text-align: center !important;
                margin-top: 1rem;
            }
            
            /* Adjust spacing for mobile */
            .space-x-4 > * {
                margin-left: 0 !important;
                margin-right: 0 !important;
            }
            
            /* Mobile preview panel */
            #previewContainer {
                margin-top: 2rem;
            }
            
            /* Mobile text sizes */
            h1 {
                font-size: 1.75rem !important;
                letter-spacing: 4px !important;
            }
            
            h2 {
                font-size: 1.5rem !important;
            }
            
            h3 {
                font-size: 1rem !important;
            }
            
            /* Mobile padding adjustments */
            .container {
                padding-left: 1rem !important;
                padding-right: 1rem !important;
            }
            
            /* Hide desktop/mobile toggle buttons on very small screens */
            @media (max-width: 480px) {
                #desktopBtn, #mobileBtn {
                    padding: 0.25rem 0.5rem !important;
                    font-size: 0.625rem !important;
                }
            }
        }
        
        /* Tablet adjustments */
        @media (min-width: 768px) and (max-width: 1024px) {
            .container {
                max-width: 100%;
                padding-left: 2rem;
                padding-right: 2rem;
            }
            
            .form-grid {
                gap: 1.5rem;
            }
        }
        
        /* Mobile-first responsive utilities */
        @media (max-width: 640px) {
            /* Stack form sections */
            .border-b {
                padding-bottom: 1.5rem !important;
            }
            
            /* Form inputs */
            .form-input {
                font-size: 16px !important; /* Prevents zoom on iOS */
            }
            
            /* Adjust label spacing */
            label {
                font-size: 0.875rem !important;
            }
            
            /* Mobile-friendly select dropdowns */
            select {
                background-size: 16px !important;
            }
            
            /* Checkbox alignment */
            input[type="checkbox"] {
                width: 18px;
                height: 18px;
            }
        }
    </style>
</head>
<body class="bg-gray-50">
    
    <!-- Header -->
    <header class="bg-black border-b-4 border-[#d4af36]">
        <div class="container mx-auto px-6 py-6">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-white text-3xl font-light tracking-[8px]" style="font-family: Georgia, serif;">MORRY</h1>
                    <p class="text-[#d4af36] text-xs tracking-[3px] uppercase mt-1">Ultra Modern Hospital</p>
                </div>
                <div class="text-right">
                    <p class="text-gray-400 text-sm">Email Management System</p>
                    <p class="text-gray-500 text-xs mt-1">Secure Portal v2.0</p>
                </div>
            </div>
        </div>
    </header>
    
    <!-- Main Content -->
    <div class="container mx-auto px-6 py-8">
        
        <!-- Page Title -->
        <div class="mb-8">
            <h2 class="text-2xl font-light text-gray-800 mb-2" style="font-family: Georgia, serif;">Compose Professional Email</h2>
            <div class="w-16 h-0.5 bg-[#d4af36]"></div>
        </div>
        
        <!-- Form and Preview Grid -->
        <div class="grid lg:grid-cols-2 gap-8 form-grid">
            
            <!-- Email Composition Form -->
            <div class="bg-white rounded-lg shadow-lg p-8">
                <form id="emailForm" class="space-y-6" method="post" action="send.php" enctype="multipart/form-data">
                    
                    <!-- Recipient Section -->
                    <div class="border-b pb-6">
                        <h3 class="text-lg font-semibold text-gray-800 mb-4 uppercase tracking-wider text-sm">Recipient Information</h3>
                        
                        <div class="space-y-4">

                            

                            <!-- To Email -->
                            <div>
                                <label for="toEmail" class="block text-sm font-medium text-gray-700 mb-2">
                                    To Email <span class="text-red-500">*</span>
                                </label>
                                <input type="email" id="toEmail" name="toEmail" required multiple
                                    class="form-input w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none transition-colors"
                                    placeholder="patient@example.com">
                                <p class="text-xs text-gray-500 mt-1">Separate multiple emails with commas</p>
                            </div>
                            
                            <!-- From Email -->
                            <div>
                                <label for="fromEmail" class="block text-sm font-medium text-gray-700 mb-2">
                                    From Email <span class="text-red-500">*</span>
                                </label>
                                <input type="email" id="fromEmail" name="fromEmail" required
                                    class="form-input w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none transition-colors"
                                    placeholder="sender@example.com">
                                <p class="text-xs text-gray-500 mt-1">The email address this message will be sent from.</p>
                            </div>
                            
                            <!-- Sender's Name -->
                            <div>
                                <label for="senderName" class="block text-sm font-medium text-gray-700 mb-2">
                                    Sender's Name <span class="text-red-500">*</span>
                                </label>
                                <input type="text" id="senderName" name="senderName" required
                                    class="form-input w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none transition-colors"
                                    placeholder="e.g., Dr. Jane Doe">
                                <p class="text-xs text-gray-500 mt-1">This name will appear in the recipient's inbox.</p>
                            </div>
                            
                            <!-- Reply-To Email -->
                            <div>
                                <label for="replyTo" class="block text-sm font-medium text-gray-700 mb-2">
                                    Reply-To Email
                                </label>
                                <input type="email" id="replyTo" name="reply_to"
                                    class="form-input w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none transition-colors"
                                    placeholder="replyto@example.com (optional)">
                                <p class="text-xs text-gray-500 mt-1">Optional. Replies will go to this address. Leave blank to send without a Reply-To header.</p>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Message Details Section -->
                    <div class="border-b pb-6">
                        <h3 class="text-lg font-semibold text-gray-800 mb-4 uppercase tracking-wider text-sm">Message Details</h3>
                        
                        <div class="space-y-4">

                            

                            <!-- Subject -->
                            <div>
                                <label for="subject" class="block text-sm font-medium text-gray-700 mb-2">
                                    Email Subject <span class="text-red-500">*</span>
                                </label>
                                <input type="text" id="subject" name="subject" required
                                    class="form-input w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none transition-colors"
                                    placeholder="Your Health Consultation Update">
                            </div>
                            
                            <!-- Patient Name -->
                            <div>
                                <label for="patientName" class="block text-sm font-medium text-gray-700 mb-2">
                                    Patient Name <span class="text-red-500">*</span>
                                </label>
                                <input type="text" id="patientName" name="patientName" required
                                    class="form-input w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none transition-colors"
                                    placeholder="Mr./Mrs./Ms. [Name]">
                            </div>
                            
                            <!-- Email Type -->
                            <div>
                                <label for="emailType" class="block text-sm font-medium text-gray-700 mb-2">
                                    Email Type <span class="text-red-500">*</span>
                                </label>
                                <select id="emailType" name="emailType" required
                                    class="form-input w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none transition-colors">
                                    <option value="">Select Email Type</option>
                                    <option value="appointment">Appointment Confirmation</option>
                                    <option value="reminder">Appointment Reminder</option>
                                    <option value="followup">Follow-up Care</option>
                                    <option value="results">Test Results Available</option>
                                    <option value="welcome">Welcome to Hospital</option>
                                    <option value="general">General Communication</option>
                                    <option value="billing">Billing Statement</option>
                                    <option value="newsletter">Health Newsletter</option>
                                </select>
                            </div>
                            
                            <!-- Custom Message -->
                            <div>
                                <label for="customMessage" class="block text-sm font-medium text-gray-700 mb-2">
                                    Custom Message Content
                                </label>
                                <textarea id="customMessage" name="customMessage" rows="4"
                                    class="form-input w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none transition-colors"
                                    placeholder="Enter any additional message content here. This will replace the default message in the template."></textarea>
                            </div>
                            
                            <!-- Appointment Details (Optional) -->
                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <label for="appointmentDate" class="block text-sm font-medium text-gray-700 mb-2">
                                        Appointment Date
                                    </label>
                                    <input type="date" id="appointmentDate" name="appointmentDate"
                                        class="form-input w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none transition-colors">
                                </div>
                                <div>
                                    <label for="appointmentTime" class="block text-sm font-medium text-gray-700 mb-2">
                                        Appointment Time
                                    </label>
                                    <input type="time" id="appointmentTime" name="appointmentTime"
                                        class="form-input w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none transition-colors">
                                </div>
                            </div>
                            
                            <!-- Department -->
                            <div>
                                <label for="department" class="block text-sm font-medium text-gray-700 mb-2">
                                    Department/Service
                                </label>
                                <select id="department" name="department"
                                    class="form-input w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none transition-colors">
                                    <option value="">Select Department</option>
                                    <option value="cardiology">Cardiology</option>
                                    <option value="neurology">Neurology</option>
                                    <option value="orthopedics">Orthopedics</option>
                                    <option value="pediatrics">Pediatrics</option>
                                    <option value="radiology">Radiology</option>
                                    <option value="emergency">Emergency Medicine</option>
                                    <option value="general">General Medicine</option>
                                    <option value="surgery">Surgery</option>
                                </select>
                            </div>
                            
                            <!-- Doctor Name -->
                            <div>
                                <label for="doctorName" class="block text-sm font-medium text-gray-700 mb-2">
                                    Attending Physician
                                </label>
                                <input type="text" id="doctorName" name="doctorName"
                                    class="form-input w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none transition-colors"
                                    placeholder="Dr. [Name]">
                            </div>
                        </div>
                    </div>
                    
                    <!-- Attachments Section -->
                    <div class="border-b pb-6">
                        <h3 class="text-lg font-semibold text-gray-800 mb-4 uppercase tracking-wider text-sm">Attachments</h3>
                        <div>
                            <label for="attachments" class="block text-sm font-medium text-gray-700 mb-2">
                                Attach Files
                            </label>
                            <input type="file" id="attachments" name="attachments[]" multiple
                                class="form-input w-full px-4 py-2 border border-gray-300 rounded-md focus:outline-none transition-colors"
                                accept=".pdf,.doc,.docx,.xls,.xlsx,.txt,.jpg,.jpeg,.png,.gif,.bmp,.webp,.svg">
                            <p class="text-xs text-gray-500 mt-1">You can attach images (JPG, PNG, GIF, etc.) and documents (PDF, Word, Excel, TXT). Maximum 10MB per file.</p>
                        </div>
                    </div>
                    
                    <div class="flex justify-end items-center pt-4 space-x-4">
                        <button type="button" onclick="previewEmail()"
                            class="px-8 py-2.5 bg-[#d4af36] text-white rounded-md hover:bg-[#c39f30] transition-colors font-medium text-sm uppercase tracking-wider">
                            Preview
                        </button>
                        
                        <button type="button" onclick="resetForm()"
                            class="px-8 py-2.5 border border-gray-300 text-gray-700 rounded-md hover:bg-gray-50 transition-colors font-medium text-sm uppercase tracking-wider">
                            Clear Form
                        </button>
                        
                        <button type="submit"
                            class="px-8 py-2.5 bg-black text-white rounded-md hover:bg-gray-900 transition-colors font-medium text-sm uppercase tracking-wider">
                            Send Email
                        </button>
                    </div>
                </form>
            </div>
            
            <!-- Email Preview Panel -->
            <div class="bg-white rounded-lg shadow-lg p-8">
                <div class="flex justify-between items-center mb-6">
                    <h3 class="text-lg font-semibold text-gray-800 uppercase tracking-wider text-sm">Email Preview</h3>
                    <div class="flex space-x-2">
                        <button onclick="toggleDevice('desktop')" id="desktopBtn"
                            class="px-3 py-1 text-xs bg-black text-white rounded">
                            Desktop
                        </button>
                        <button onclick="toggleDevice('mobile')" id="mobileBtn"
                            class="px-3 py-1 text-xs bg-gray-300 text-gray-700 rounded">
                            Mobile
                        </button>
                    </div>
                </div>
                
                <div id="previewContainer" class="preview-container border border-gray-200 rounded-lg p-4 bg-gray-50">
                    <div id="emailPreview" class="bg-white mx-auto transition-all duration-300" style="max-width: 600px;">
                        <!-- Preview will be loaded here -->
                        <div class="text-center py-20 text-gray-400">
                            <svg class="w-20 h-20 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" 
                                    d="M3 19v-8.93a2 2 0 01.89-1.664l7-4.666a2 2 0 012.22 0l7 4.666A2 2 0 0121 10.07V19M3 19a2 2 0 002 2h14a2 2 0 002-2M3 19l6.75-4.5M21 19l-6.75-4.5M3 10l6.75 4.5M21 10l-6.75 4.5m0 0l-1.14.76a2 2 0 01-2.22 0l-1.14-.76"></path>
                            </svg>
                            <p class="text-lg font-medium">Email Preview</p>
                            <p class="text-sm mt-2">Fill in the form and click "Preview" to see your email</p>
                        </div>
                    </div>
                </div>
                
                <!-- Preview Info -->
                <div class="mt-6 p-4 bg-gray-50 rounded-lg">
                    <h4 class="text-sm font-semibold text-gray-700 mb-3">Preview Information</h4>
                    <div class="space-y-2 text-xs text-gray-600">
                        <div class="flex justify-between">
                            <span>Email Client Compatibility:</span>
                            <span class="font-medium">99.8%</span>
                        </div>
                        <div class="flex justify-between">
                            <span>Mobile Responsive:</span>
                            <span class="font-medium text-green-600">✓ Yes</span>
                        </div>
                        <div class="flex justify-between">
                            <span>Last Modified:</span>
                            <span class="font-medium" id="lastModified">-</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Status Messages -->
        <div id="statusMessage" class="hidden mt-6">
            <!-- Status messages will appear here -->
        </div>
    </div>
    
    <!-- Footer -->
    <footer class="bg-gray-900 text-gray-400 py-8 mt-12">
        <div class="container mx-auto px-6">
            <div class="flex justify-between items-center">
                <div>
                    <p class="text-sm">© 2024 Morry Ultra Modern Hospital - Email Management System</p>
                    <p class="text-xs mt-1">Secure HIPAA Compliant Platform</p>
                </div>
                <div class="text-right">
                    <p class="text-xs">Support: it@morrycares.com.com | Ext: 5555</p>
                </div>
            </div>
        </div>
    </footer>
    
    <script>
        // Toggle schedule options
        function toggleScheduleOptions() {
            const checkbox = document.getElementById('scheduleSend');
            const options = document.getElementById('scheduleOptions');
            if (checkbox.checked) {
                options.classList.remove('hidden');
            } else {
                options.classList.add('hidden');
            }
        }
        
        // Toggle device preview
        function toggleDevice(device) {
            const preview = document.getElementById('emailPreview');
            const desktopBtn = document.getElementById('desktopBtn');
            const mobileBtn = document.getElementById('mobileBtn');
            
            if (device === 'mobile') {
                preview.style.maxWidth = '320px';
                mobileBtn.className = 'px-3 py-1 text-xs bg-black text-white rounded';
                desktopBtn.className = 'px-3 py-1 text-xs bg-gray-300 text-gray-700 rounded';
            } else {
                preview.style.maxWidth = '600px';
                desktopBtn.className = 'px-3 py-1 text-xs bg-black text-white rounded';
                mobileBtn.className = 'px-3 py-1 text-xs bg-gray-300 text-gray-700 rounded';
            }
        }
        
        // Preview email function - now using the embedded template
        function previewEmail() {
            const patientName = document.getElementById('patientName').value || 'Distinguished Patient';
            const customMessage = document.getElementById('customMessage').value;
            const emailType = document.getElementById('emailType').value;
            const appointmentDate = document.getElementById('appointmentDate').value;
            const appointmentTime = document.getElementById('appointmentTime').value;
            const department = document.getElementById('department').value;
            const doctorName = document.getElementById('doctorName').value;
            
            // Email template HTML (embedded)
            let emailTemplateHTML = `
                <!-- Email Container -->
                <table role="presentation" width="100%" cellpadding="0" cellspacing="0" style="background-color: #f4f7fa; padding: 20px 0;">
                    <tr>
                        <td align="center">
                            
                            <!-- Main Email Table -->
                            <table role="presentation" width="600" cellpadding="0" cellspacing="0" class="email-container" style="background-color: #ffffff; max-width: 600px; box-shadow: 0 4px 12px rgba(0,0,0,0.1);">
                                
                                <!-- Header -->
                                <tr>
                                    <td class="header-padding" style="background-color: #0a0a0a; padding: 45px 40px; text-align: center; border-bottom: 3px solid #d4af36;">
                                        <table role="presentation" width="100%" cellpadding="0" cellspacing="0">
                                            <tr>
                                                <td align="center">
                                                    <!-- Logo/Hospital Name -->
                                                    <div style="padding: 10px 0;">
                                                        <h1 class="header-title" style="margin: 0; color: #ffffff; font-size: 28px; font-weight: 200; letter-spacing: 8px; font-family: 'Georgia', serif;">
                                                            MORRY
                                                        </h1>
                                                        <div style="width: 60px; height: 1px; background-color: #d4af36; margin: 12px auto;"></div>
                                                        <p class="header-subtitle" style="margin: 10px 0 0 0; color: #d4af36; font-size: 10px; letter-spacing: 3px; text-transform: uppercase; font-weight: 300;">Ultra Modern Hospital</p>
                                                    </div>
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                                
                                <!-- Hero Section -->
                                <tr>
                                    <td class="hero-padding" style="background-color: #fafafa; padding: 60px 50px; text-align: left; border-bottom: 1px solid #dadada;">
                                        <h2 class="hero-title" style="margin: 0 0 20px 0; color: #0a0a0a; font-size: 24px; font-weight: 300; line-height: 1.3; letter-spacing: 1px; font-family: 'Georgia', serif;">Excellence in Medical Care</h2>
                                        <div style="width: 40px; height: 2px; background-color: #d4af36; margin: 0 0 20px 0;"></div>
                                        <p style="margin: 0; color: #4a4a4a; font-size: 14px; line-height: 1.8; font-weight: 300; font-family: 'Times New Roman', serif;">Morry Ultra Modern Hospital represents the pinnacle of contemporary medical practice, combining advanced diagnostic capabilities with personalized patient care protocols.</p>
                                    </td>
                                </tr>
                                
                                <!-- Main Content -->
                                <tr>
                                    <td class="content-padding" style="padding: 50px;">
                                        
                                        <p style="margin: 0 0 25px 0; color: #1a1a1a; font-size: 14px; line-height: 1.6; font-family: 'Times New Roman', serif;">Dear ${patientName},</p>
                                        
                                        ${customMessage ? `<p style="margin: 0 0 35px 0; color: #3a3a3a; font-size: 13px; line-height: 1.9; font-family: 'Times New Roman', serif;">${customMessage}</p>` : ''}
                                        
                                        <p style="margin: 0 0 35px 0; color: #3a3a3a; font-size: 13px; line-height: 1.9; font-family: 'Times New Roman', serif;">
                                            It is our privilege to correspond with you regarding your healthcare requirements. The <strong style="color: #0a0a0a; font-weight: 600;">Morry Ultra Modern Hospital</strong> has established itself as a premier medical institution, dedicated to delivering unparalleled Hospitalal excellence through the integration of cutting-edge medical technologies and evidence-based treatment methodologies.
                                        </p>
                                        
                                        ${appointmentDate && appointmentTime ? `
                                        <div style="background-color: #f0f0f0; padding: 20px; margin: 20px 0; border-left: 3px solid #d4af36;">
                                            <h4 style="margin: 0 0 10px 0; color: #0a0a0a; font-size: 14px;">Appointment Details</h4>
                                            <p style="margin: 0; color: #3a3a3a; font-size: 13px;">
                                                Date: ${new Date(appointmentDate).toLocaleDateString('en-US', { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' })}<br>
                                                Time: ${appointmentTime}<br>
                                                ${department ? `Department: ${department}<br>` : ''}
                                                ${doctorName ? `Physician: ${doctorName}` : ''}
                                            </p>
                                        </div>` : ''}
                                        
                                        <!-- Feature Boxes -->
                                        <table role="presentation" width="100%" cellpadding="0" cellspacing="0" style="margin: 40px 0;">
                                            <tr>
                                                <td class="feature-box" style="padding: 0 15px 25px 0; width: 50%;">
                                                    <div class="feature-box-content" style="background-color: #fafafa; border: 1px solid #d0d0d0; border-left: 2px solid #d4af36; padding: 25px; border-radius: 0;">
                                                        <h3 style="margin: 0 0 10px 0; color: #0a0a0a; font-size: 13px; font-weight: 600; letter-spacing: 1px; text-transform: uppercase;">Advanced Infrastructure</h3>
                                                        <p style="margin: 0; color: #4a4a4a; font-size: 12px; line-height: 1.7; font-family: 'Times New Roman', serif;">State-of-the-art diagnostic and therapeutic equipment</p>
                                                    </div>
                                                </td>
                                                <td class="feature-box" style="padding: 0 0 25px 15px; width: 50%;">
                                                    <div class="feature-box-content" style="background-color: #fafafa; border: 1px solid #d0d0d0; border-left: 2px solid #d4af36; padding: 25px; border-radius: 0;">
                                                        <h3 style="margin: 0 0 10px 0; color: #0a0a0a; font-size: 13px; font-weight: 600; letter-spacing: 1px; text-transform: uppercase;">Hospitalal Excellence</h3>
                                                        <p style="margin: 0; color: #4a4a4a; font-size: 12px; line-height: 1.7; font-family: 'Times New Roman', serif;">Board-certified specialists with distinguished credentials</p>
                                                    </div>
                                                </td>
                                            </tr>
                                        </table>
                                        
                                        <p style="margin: 40px 0 35px 0; color: #3a3a3a; font-size: 13px; line-height: 1.9; font-family: 'Times New Roman', serif;">
                                            We cordially invite you to schedule a consultation at your earliest convenience to experience the exceptional standard of care that distinguishes our institution.
                                        </p>
                                        
                                        <!-- Call to Action Button -->
                                        <table role="presentation" width="100%" cellpadding="0" cellspacing="0">
                                            <tr>
                                                <td align="center" style="padding: 15px 0 40px 0;">
                                                    <a href="#" class="cta-button" style="display: inline-block; background-color: #0a0a0a; color: #ffffff; text-decoration: none; padding: 18px 50px; border: 1px solid #0a0a0a; font-size: 12px; font-weight: 400; letter-spacing: 2px; text-transform: uppercase; font-family: 'Georgia', serif;">
                                                        Schedule Consultation
                                                    </a>
                                                </td>
                                            </tr>
                                        </table>
                                        
                                    </td>
                                </tr>
                                
                                <!-- Contact Information -->
                                <tr>
                                    <td class="content-padding" style="background-color: #0a0a0a; padding: 45px 50px; border-top: 3px solid #d4af36;">
                                        <table role="presentation" width="100%" cellpadding="0" cellspacing="0">
                                            <tr>
                                                <td style="padding-bottom: 30px;">
                                                    <h3 style="margin: 0 0 5px 0; color: #ffffff; font-size: 14px; font-weight: 400; text-align: center; letter-spacing: 2px; text-transform: uppercase; font-family: 'Georgia', serif;">Contact Information</h3>
                                                    <div style="width: 40px; height: 1px; background-color: #d4af36; margin: 15px auto 0;"></div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <table role="presentation" width="100%" cellpadding="0" cellspacing="0">
                                                        <tr>
                                                            <td class="contact-item" style="text-align: center; padding: 15px;">
                                                                <p style="margin: 0; color: #d4af36; font-size: 11px; text-transform: uppercase; letter-spacing: 1px; font-weight: 600;">Telephone</p>
                                                                <p style="margin: 5px 0 0 0; color: #ffffff; font-size: 13px; font-family: 'Times New Roman', serif;">+1 (555) 123-4567</p>
                                                            </td>
                                                            <td class="contact-item" style="text-align: center; padding: 15px; border-left: 1px solid #333333; border-right: 1px solid #333333;">
                                                                <p style="margin: 0; color: #d4af36; font-size: 11px; text-transform: uppercase; letter-spacing: 1px; font-weight: 600;">Email</p>
                                                                <p style="margin: 5px 0 0 0; color: #ffffff; font-size: 13px; font-family: 'Times New Roman', serif;">mail@morrycares.com.com</p>
                                                            </td>
                                                            <td class="contact-item" style="text-align: center; padding: 15px;">
                                                                <p style="margin: 0; color: #d4af36; font-size: 11px; text-transform: uppercase; letter-spacing: 1px; font-weight: 600;">Location</p>
                                                                <p style="margin: 5px 0 0 0; color: #ffffff; font-size: 13px; font-family: 'Times New Roman', serif;">123 Harley Street<br>Medical District, NY 10001</p>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                                
                            </table>
                            
                        </td>
                    </tr>
                </table>
            `;
            
            // Display in preview
            document.getElementById('emailPreview').innerHTML = emailTemplateHTML;
            
            // Update last modified time
            document.getElementById('lastModified').textContent = new Date().toLocaleString();
        }
        
        // Reset form
        function resetForm() {
            if (confirm('Are you sure you want to reset the form? All data will be lost.')) {
                document.getElementById('emailForm').reset();
                document.getElementById('emailPreview').innerHTML = `
                    <div class="text-center py-20 text-gray-400">
                        <svg class="w-20 h-20 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" 
                                d="M3 19v-8.93a2 2 0 01.89-1.664l7-4.666a2 2 0 012.22 0l7 4.666A2 2 0 0121 10.07V19M3 19a2 2 0 002 2h14a2 2 0 002-2M3 19l6.75-4.5M21 19l-6.75-4.5M3 10l6.75 4.5M21 10l-6.75 4.5m0 0l-1.14.76a2 2 0 01-2.22 0l-1.14-.76"></path>
                        </svg>
                        <p class="text-lg font-medium">Email Preview</p>
                        <p class="text-sm mt-2">Fill in the form and click "Preview" to see your email</p>
                    </div>`;
                showStatus('Form has been reset', 'success');
            }
        }
        
        // Save draft
        function saveDraft() {
            const formData = new FormData(document.getElementById('emailForm'));
            const draft = {};
            formData.forEach((value, key) => {
                draft[key] = value;
            });
            
            // Save to localStorage (in production, this would save to a database)
            localStorage.setItem('emailDraft', JSON.stringify(draft));
            localStorage.setItem('draftTimestamp', new Date().toISOString());
            
            showStatus('Draft saved successfully', 'success');
        }
        
        // Show status message
        function showStatus(message, type) {
            const statusDiv = document.getElementById('statusMessage');
            statusDiv.className = `p-4 rounded-lg ${type === 'error' ? 'bg-red-100 text-red-700' : 'bg-green-100 text-green-700'}`;
            statusDiv.innerHTML = `
                <div class="flex items-center">
                    <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                        ${type === 'error' 
                            ? '<path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"></path>'
                            : '<path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>'
                        }
                    </svg>
                    <span>${message}</span>
                </div>`;
            
            setTimeout(() => {
                statusDiv.className = 'hidden';
            }, 5000);
        }
        

        
        // Load draft on page load if exists
        window.addEventListener('load', function() {
            const draft = localStorage.getItem('emailDraft');
            if (draft) {
                const draftData = JSON.parse(draft);
                const timestamp = localStorage.getItem('draftTimestamp');
                
                if (confirm(`A draft from ${new Date(timestamp).toLocaleString()} was found. Would you like to restore it?`)) {
                    Object.keys(draftData).forEach(key => {
                        const element = document.getElementById(key);
                        if (element) {
                            if (element.type === 'checkbox') {
                                element.checked = draftData[key] === 'on';
                            } else {
                                element.value = draftData[key];
                            }
                        }
                    });
                    showStatus('Draft restored successfully', 'success');
                }
            }
        });
    </script>
    
</body>
</html>