<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require __DIR__ . '/vendor/autoload.php';

function clean($v){return trim($v ?? '');}
function esc($v){return htmlspecialchars($v, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');}

$fromEmail = clean($_POST['fromEmail'] ?? '');
$toRaw = clean($_POST['toEmail'] ?? '');
$toEmails = array_values(array_filter(preg_split('/[,\s;]+/', $toRaw)));
$senderName = clean($_POST['senderName'] ?? '');
$replyTo = clean($_POST['reply_to'] ?? '');
$subject = clean($_POST['subject'] ?? '');
$message = clean($_POST['customMessage'] ?? ($_POST['message'] ?? ''));
$patientName = clean($_POST['patientName'] ?? '');

$errors = [];
if(!filter_var($fromEmail, FILTER_VALIDATE_EMAIL)){$errors[] = 'Invalid From Email address.';}
if(empty($toEmails)){$errors[] = 'To Email is required.';}else{foreach($toEmails as $addr){if(!filter_var($addr, FILTER_VALIDATE_EMAIL)){$errors[] = 'Invalid To Email address: '.$addr;break;}}}
if($senderName === ''){$errors[] = 'Sender Name is required.';}
if($subject === ''){$errors[] = 'Email Subject is required.';}
if($message === ''){$errors[] = 'Message is required.';}

// Handle file attachments
$attachments = [];
$maxFileSize = 10 * 1024 * 1024; // 10MB
$allowedExtensions = ['pdf', 'doc', 'docx', 'xls', 'xlsx', 'txt', 'jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp', 'svg'];

if(isset($_FILES['attachments']) && !empty($_FILES['attachments']['name'][0])){
    $files = $_FILES['attachments'];
    $fileCount = count($files['name']);
    
    for($i = 0; $i < $fileCount; $i++){
        if($files['error'][$i] === UPLOAD_ERR_OK){
            $fileName = $files['name'][$i];
            $fileTmpPath = $files['tmp_name'][$i];
            $fileSize = $files['size'][$i];
            $fileExtension = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
            
            // Validate file size
            if($fileSize > $maxFileSize){
                $errors[] = "File '{$fileName}' exceeds maximum size of 10MB.";
                continue;
            }
            
            // Validate file extension
            if(!in_array($fileExtension, $allowedExtensions)){
                $errors[] = "File '{$fileName}' has an invalid file type. Allowed: images and documents.";
                continue;
            }
            
            // Store valid attachment info
            $attachments[] = [
                'path' => $fileTmpPath,
                'name' => $fileName
            ];
        }elseif($files['error'][$i] !== UPLOAD_ERR_NO_FILE){
            $errors[] = "Error uploading file '{$files['name'][$i]}'.";
        }
    }
}

function renderPage($title, $contentHtml){echo '<!doctype html><html lang="en"><head><meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1"><title>'.esc($title).'</title><style>html,body{height:100%}body{margin:0;font-family:system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,sans-serif;background:linear-gradient(135deg,#6a6ef6 0%,#6a6ef6 40%,#6b49b6 100%);display:flex;align-items:center;justify-content:center;color:#1f2937} .card{width:680px;max-width:92vw;background:#fff;border-radius:16px;box-shadow:0 20px 40px rgba(0,0,0,.15);padding:36px} h1{margin:0 0 10px;font-size:32px;text-align:center} .msg{padding:16px 18px;border-radius:10px;margin:8px 0;font-size:16px} .ok{background:#e8faf0;color:#14532d;border:1px solid #86efac} .err{background:#fef2f2;color:#7f1d1d;border:1px solid #fca5a5} .actions{display:flex;gap:10px;justify-content:center;margin-top:16px} .btn{border:none;border-radius:10px;background:linear-gradient(90deg,#6780ff,#7a49b6);color:#fff;padding:12px 16px;font-weight:700;cursor:pointer} pre{white-space:pre-wrap;word-wrap:break-word}</style></head><body><div class="card"><h1>'.esc($title).'</h1>'.$contentHtml.'<div class="actions"><a href="index.php"><button class="btn" type="button">Back to Form</button></a></div></div></body></html>';}

if(!empty($errors)){
    $list = '<ul>';foreach($errors as $e){$list .= '<li>'.esc($e).'</li>';} $list .= '</ul>';
    renderPage('Message Not Sent', '<div class="msg err"><strong>Please fix the following:</strong>'.$list.'</div>');
    exit;
}

function configureMailer($secure, $port){
    $mail = new PHPMailer(true);
    $mail->isSMTP();
    $mail->Host = 'morrycares.com';
    $mail->SMTPAuth = true;
    $mail->Username = 'mail@morrycares.com';
    $mail->Password = 'Kenneth7&4';
    $mail->SMTPSecure = $secure; // PHPMailer::ENCRYPTION_STARTTLS or ENCRYPTION_SMTPS
    $mail->Port = $port; // 587 or 465
    return $mail;
}

$attempts = [PHPMailer::ENCRYPTION_STARTTLS => 587, PHPMailer::ENCRYPTION_SMTPS => 465];
$sent = false; $details = '';

foreach($attempts as $secure => $port){
    try{
        $mail = configureMailer($secure, $port);
        $mail->setFrom($fromEmail, $senderName, true);
        $mail->Sender = 'mail@morrycares.com'; // Envelope sender
        if($replyTo !== '' && filter_var($replyTo, FILTER_VALIDATE_EMAIL)){$mail->addReplyTo($replyTo, $senderName);}
        foreach($toEmails as $addr){$mail->addAddress($addr);}        $mail->Subject = $subject;
        $mail->isHTML(true);
        $templatePath = __DIR__ . '/email_template.php';
        if(file_exists($templatePath)){
            $safeMsg = nl2br(esc($message));
            ob_start();
            $EMAIL_MESSAGE = $safeMsg;
            include $templatePath;
            $htmlBody = ob_get_clean();
            $mail->Body = $htmlBody;
        }else{
            $mail->Body = '<p>'.nl2br(esc($message)).'</p>';
        }
        $mail->AltBody = $message;
        
        // Add attachments
        foreach($attachments as $attachment){
            try{
                $mail->addAttachment($attachment['path'], $attachment['name']);
            }catch(Exception $attachEx){
                // Continue sending even if one attachment fails
            }
        }
        
        $mail->send();
        $sent = true; $details = 'Sent via SMTP '.($secure === PHPMailer::ENCRYPTION_STARTTLS ? 'TLS' : 'SSL').' (port '.$port.').';
        break;
    }catch(Exception $ex){
        $details .= ($details ? ' ' : '').'Attempt on port '.$port.' failed: '.esc($mail->ErrorInfo).'.';
    }
}

if($sent){
    $attachmentInfo = count($attachments) > 0 ? '<div>Attachments: '.count($attachments).' file(s)</div>' : '';
    $html = '<div class="msg ok"><strong>Your message has been sent successfully.</strong><div>To: '.esc(implode(', ', $toEmails)).'</div><div>From: '.esc($fromEmail).' ('.esc($senderName).')</div><div>Subject: '.esc($subject).'</div>'.$attachmentInfo.'<div style="margin-top:8px;color:#64748b">'.esc($details).'</div></div>';
    renderPage('Message Sent', $html);
}else{
    $html = '<div class="msg err"><strong>We could not send your message.</strong><div style="margin-top:8px">'.esc($details ?: 'Unknown error').'</div></div>';
    renderPage('Message Not Sent', $html);
}