<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Morry Ultra Modern Hospital - Email Template</title>
    <style>
        /* Mobile Responsive Styles */
        @media only screen and (max-width: 600px) {
            .email-container {
                width: 100% !important;
                max-width: 100% !important;
            }
            
            .header-padding {
                padding: 30px 20px !important;
            }
            
            .content-padding {
                padding: 30px 20px !important;
            }
            
            .hero-padding {
                padding: 40px 20px !important;
            }
            
            .header-title {
                font-size: 24px !important;
            }
            
            .header-subtitle {
                font-size: 11px !important;
            }
            
            .hero-icon {
                width: 60px !important;
                height: 60px !important;
            }
            
            .hero-icon span {
                font-size: 30px !important;
                line-height: 60px !important;
            }
            
            .hero-title {
                font-size: 22px !important;
            }
            
            .feature-box {
                display: block !important;
                width: 100% !important;
                padding: 0 0 15px 0 !important;
            }
            
            .feature-box-content {
                margin-bottom: 15px !important;
            }
            
            .cta-button {
                padding: 14px 30px !important;
                font-size: 15px !important;
            }
            
            .contact-item {
                display: block !important;
                width: 100% !important;
                padding: 10px 0 !important;
            }
            
            .footer-padding {
                padding: 25px 20px !important;
            }
            
            .social-icon {
                width: 35px !important;
                height: 35px !important;
                line-height: 35px !important;
                font-size: 16px !important;
                margin: 0 5px !important;
            }
        }
    </style>
</head>
<body style="margin: 0; padding: 0; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; background-color: #f4f7fa;">
    
    <!-- Email Container -->
    <table role="presentation" width="100%" cellpadding="0" cellspacing="0" style="background-color: #f4f7fa; padding: 20px 0;">
        <tr>
            <td align="center">
                
                <!-- Main Email Table -->
                <table role="presentation" width="600" cellpadding="0" cellspacing="0" class="email-container" style="background-color: #ffffff; max-width: 600px; box-shadow: 0 4px 12px rgba(0,0,0,0.1);">
                    
                    <!-- Header -->
                    <tr>
                        <td class="header-padding" style="background-color: #0a0a0a; padding: 45px 40px; text-align: center; border-bottom: 3px solid #d4af36;">
                            <table role="presentation" width="100%" cellpadding="0" cellspacing="0">
                                <tr>
                                    <td align="center">
                                        <!-- Logo/Hospital Name -->
                                        <div style="padding: 10px 0;">
                                            <h1 class="header-title" style="margin: 0; color: #ffffff; font-size: 28px; font-weight: 200; letter-spacing: 8px; font-family: 'Georgia', serif;">
                                                MORRY
                                            </h1>
                                            <div style="width: 60px; height: 1px; background-color: #d4af36; margin: 12px auto;"></div>
                                            <p class="header-subtitle" style="margin: 10px 0 0 0; color: #d4af36; font-size: 10px; letter-spacing: 3px; text-transform: uppercase; font-weight: 300;">Ultra Modern Hospital</p>
                                        </div>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    
                    <!-- Hero Section -->
                    <tr>
                        <td class="hero-padding" style="background-color: #fafafa; padding: 60px 50px; text-align: left; border-bottom: 1px solid #dadada;">
                            <h2 class="hero-title" style="margin: 0 0 20px 0; color: #0a0a0a; font-size: 24px; font-weight: 300; line-height: 1.3; letter-spacing: 1px; font-family: 'Georgia', serif;">Excellence in Medical Care</h2>
                            <div style="width: 40px; height: 2px; background-color: #d4af36; margin: 0 0 20px 0;"></div>
                            <p style="margin: 0; color: #4a4a4a; font-size: 14px; line-height: 1.8; font-weight: 300; font-family: 'Times New Roman', serif;">Morry Ultra Modern Hospital represents the pinnacle of contemporary medical practice, combining advanced diagnostic capabilities with personalized patient care protocols.</p>
                        </td>
                    </tr>
                    
                    <!-- Main Content -->
                    <tr>
                        <td class="content-padding" style="padding: 50px;">
                            
                            <?php $salutationName = ($patientName !== '' ? htmlspecialchars($patientName, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8') : 'Distinguished Patient'); ?>
                            <p style="margin: 0 0 25px 0; color: #1a1a1a; font-size: 14px; line-height: 1.6; font-family: 'Times New Roman', serif;">Dear <?php echo $salutationName; ?>,</p>
                            
                            <p style="margin: 0 0 35px 0; color: #3a3a3a; font-size: 13px; line-height: 1.9; font-family: 'Times New Roman', serif;"><?php echo $EMAIL_MESSAGE; ?></p>
                            
                            <!-- Feature Boxes -->
                            <table role="presentation" width="100%" cellpadding="0" cellspacing="0" style="margin: 40px 0;">
                                <tr>
                                    <td class="feature-box" style="padding: 0 15px 25px 0; width: 50%;">
                                        <div class="feature-box-content" style="background-color: #fafafa; border: 1px solid #d0d0d0; border-left: 2px solid #d4af36; padding: 25px; border-radius: 0;">
                                            <h3 style="margin: 0 0 10px 0; color: #0a0a0a; font-size: 13px; font-weight: 600; letter-spacing: 1px; text-transform: uppercase;">Advanced Infrastructure</h3>
                                            <p style="margin: 0; color: #4a4a4a; font-size: 12px; line-height: 1.7; font-family: 'Times New Roman', serif;">State-of-the-art diagnostic and therapeutic equipment</p>
                                        </div>
                                    </td>
                                    <td class="feature-box" style="padding: 0 0 25px 15px; width: 50%;">
                                        <div class="feature-box-content" style="background-color: #fafafa; border: 1px solid #d0d0d0; border-left: 2px solid #d4af36; padding: 25px; border-radius: 0;">
                                            <h3 style="margin: 0 0 10px 0; color: #0a0a0a; font-size: 13px; font-weight: 600; letter-spacing: 1px; text-transform: uppercase;">Hospitalal Excellence</h3>
                                            <p style="margin: 0; color: #4a4a4a; font-size: 12px; line-height: 1.7; font-family: 'Times New Roman', serif;">Board-certified specialists with distinguished credentials</p>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="feature-box" style="padding: 0 15px 0 0; width: 50%;">
                                        <div class="feature-box-content" style="background-color: #fafafa; border: 1px solid #d0d0d0; border-left: 2px solid #d4af36; padding: 25px; border-radius: 0;">
                                            <h3 style="margin: 0 0 10px 0; color: #0a0a0a; font-size: 13px; font-weight: 600; letter-spacing: 1px; text-transform: uppercase;">Continuous Care</h3>
                                            <p style="margin: 0; color: #4a4a4a; font-size: 12px; line-height: 1.7; font-family: 'Times New Roman', serif;">Round-the-clock emergency and critical care services</p>
                                        </div>
                                    </td>
                                    <td class="feature-box" style="padding: 0 0 0 15px; width: 50%;">
                                        <div class="feature-box-content" style="background-color: #fafafa; border: 1px solid #d0d0d0; border-left: 2px solid #d4af36; padding: 25px; border-radius: 0;">
                                            <h3 style="margin: 0 0 10px 0; color: #0a0a0a; font-size: 13px; font-weight: 600; letter-spacing: 1px; text-transform: uppercase;">Bespoke Treatment</h3>
                                            <p style="margin: 0; color: #4a4a4a; font-size: 12px; line-height: 1.7; font-family: 'Times New Roman', serif;">Individualized therapeutic protocols and care pathways</p>
                                        </div>
                                    </td>
                                </tr>
                            </table>
                            
                            <p style="margin: 40px 0 35px 0; color: #3a3a3a; font-size: 13px; line-height: 1.9; font-family: 'Times New Roman', serif;">
                                We cordially invite you to schedule a consultation at your earliest convenience to experience the exceptional standard of care that distinguishes our institution.
                            </p>
                            
                            <!-- Call to Action Button -->
                            <table role="presentation" width="100%" cellpadding="0" cellspacing="0">
                                <tr>
                                    <td align="center" style="padding: 15px 0 40px 0;">
                                        <a href="#" class="cta-button" style="display: inline-block; background-color: #0a0a0a; color: #ffffff; text-decoration: none; padding: 18px 50px; border: 1px solid #0a0a0a; font-size: 12px; font-weight: 400; letter-spacing: 2px; text-transform: uppercase; font-family: 'Georgia', serif;">
                                            Schedule Consultation
                                        </a>
                                    </td>
                                </tr>
                            </table>
                            
                            <!-- Divider -->
                            <div style="height: 1px; background-color: #e0e0e0; margin: 40px 0;"></div>
                            
                            <!-- Additional Info -->
                            <table role="presentation" width="100%" cellpadding="0" cellspacing="0">
                                <tr>
                                    <td style="padding: 35px; background-color: #fafafa; border: 1px solid #e0e0e0;">
                                        <h3 style="margin: 0 0 25px 0; color: #0a0a0a; font-size: 14px; font-weight: 600; letter-spacing: 1.5px; text-transform: uppercase; font-family: 'Georgia', serif;">Comprehensive Medical Services</h3>
                                        <ul style="margin: 0; padding: 0 0 0 25px; color: #3a3a3a; font-size: 13px; line-height: 2.2; font-family: 'Times New Roman', serif;">
                                            <li>Internal Medicine & Executive Health Assessments</li>
                                            <li>Advanced Diagnostic Imaging & Laboratory Services</li>
                                            <li>Minimally Invasive Surgical Interventions</li>
                                            <li>Pediatric & Adolescent Medicine</li>
                                            <li>Cardiovascular Medicine & Interventional Cardiology</li>
                                            <li>Diagnostic & Interventional Radiology</li>
                                        </ul>
                                    </td>
                                </tr>
                            </table>
                            
                        </td>
                    </tr>
                    
                    <!-- Contact Information -->
                    <tr>
                        <td class="content-padding" style="background-color: #0a0a0a; padding: 45px 50px; border-top: 3px solid #d4af36;">
                            <table role="presentation" width="100%" cellpadding="0" cellspacing="0">
                                <tr>
                                    <td style="padding-bottom: 30px;">
                                        <h3 style="margin: 0 0 5px 0; color: #ffffff; font-size: 14px; font-weight: 400; text-align: center; letter-spacing: 2px; text-transform: uppercase; font-family: 'Georgia', serif;">Contact Information</h3>
                                        <div style="width: 40px; height: 1px; background-color: #d4af36; margin: 15px auto 0;"></div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <table role="presentation" width="100%" cellpadding="0" cellspacing="0">
                                            <tr>
                                                <td class="contact-item" style="text-align: center; padding: 15px;">
                                                    <p style="margin: 0; color: #d4af36; font-size: 11px; text-transform: uppercase; letter-spacing: 1px; font-weight: 600;">Telephone</p>
                                                    <p style="margin: 5px 0 0 0; color: #ffffff; font-size: 13px; font-family: 'Times New Roman', serif;">+1 (555) 123-4567</p>
                                                </td>
                                                <td class="contact-item" style="text-align: center; padding: 15px; border-left: 1px solid #333333; border-right: 1px solid #333333;">
                                                    <p style="margin: 0; color: #d4af36; font-size: 11px; text-transform: uppercase; letter-spacing: 1px; font-weight: 600;">Email</p>
                                                    <p style="margin: 5px 0 0 0; color: #ffffff; font-size: 13px; font-family: 'Times New Roman', serif;"mail@morrycares.com</p>
                                                </td>
                                                <td class="contact-item" style="text-align: center; padding: 15px;">
                                                    <p style="margin: 0; color: #d4af36; font-size: 11px; text-transform: uppercase; letter-spacing: 1px; font-weight: 600;">Location</p>
                                                    <p style="margin: 5px 0 0 0; color: #ffffff; font-size: 13px; font-family: 'Times New Roman', serif;">123 Harley Street<br>Medical District, NY 10001</p>
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    
                    <!-- Footer -->
                    <tr>
                        <td class="footer-padding" style="background-color: #1a1a1a; padding: 35px 50px; text-align: center; border-top: 1px solid #333333;">
                            
                            <!-- Social Media Icons -->
                            <table role="presentation" cellpadding="0" cellspacing="0" style="margin: 0 auto 25px auto;">
                                <tr>
                                    <td style="padding: 0;">
                                        <a href="#" style="text-decoration: none;">
                                            <div class="social-icon" style="display: inline-block; width: 40px; height: 40px; line-height: 40px; border-radius: 50%; background-color: #2a2a2a; border: 1px solid #333333; margin: 0 8px; text-align: center; font-size: 18px; color: #d4af36; transition: all 0.3s;">
                                                <!-- Facebook -->
                                                <span style="font-family: Arial, sans-serif;">f</span>
                                            </div>
                                        </a>
                                        <a href="#" style="text-decoration: none;">
                                            <div class="social-icon" style="display: inline-block; width: 40px; height: 40px; line-height: 40px; border-radius: 50%; background-color: #2a2a2a; border: 1px solid #333333; margin: 0 8px; text-align: center; font-size: 18px; color: #d4af36; transition: all 0.3s;">
                                                <!-- Twitter/X -->
                                                <span style="font-family: Arial, sans-serif;">X</span>
                                            </div>
                                        </a>
                                        <a href="#" style="text-decoration: none;">
                                            <div class="social-icon" style="display: inline-block; width: 40px; height: 40px; line-height: 40px; border-radius: 50%; background-color: #2a2a2a; border: 1px solid #333333; margin: 0 8px; text-align: center; font-size: 16px; color: #d4af36; transition: all 0.3s;">
                                                <!-- LinkedIn -->
                                                <span style="font-family: Arial, sans-serif;">in</span>
                                            </div>
                                        </a>
                                        <a href="#" style="text-decoration: none;">
                                            <div class="social-icon" style="display: inline-block; width: 40px; height: 40px; line-height: 40px; border-radius: 50%; background-color: #2a2a2a; border: 1px solid #333333; margin: 0 8px; text-align: center; font-size: 18px; color: #d4af36; transition: all 0.3s;">
                                                <!-- Instagram -->
                                                <span style="font-family: Arial, sans-serif;">◐</span>
                                            </div>
                                        </a>
                                        <a href="#" style="text-decoration: none;">
                                            <div class="social-icon" style="display: inline-block; width: 40px; height: 40px; line-height: 40px; border-radius: 50%; background-color: #2a2a2a; border: 1px solid #333333; margin: 0 8px; text-align: center; font-size: 16px; color: #d4af36; transition: all 0.3s;">
                                                <!-- YouTube -->
                                                <span style="font-family: Arial, sans-serif;">▶</span>
                                            </div>
                                        </a>
                                    </td>
                                </tr>
                            </table>
                            
                            <p style="margin: 0 0 20px 0; color: #888888; font-size: 11px; line-height: 1.8; font-family: 'Times New Roman', serif;">
                                © 2024 Morry Ultra Modern Hospital. All Rights Reserved.<br>
                                <span style="font-style: italic; color: #777777;">Excellence in Healthcare Since Establishment</span>
                            </p>
                            
                            <p style="margin: 0; color: #666666; font-size: 10px; letter-spacing: 1px;">
                                <a href="#" style="color: #666666; text-decoration: none; margin: 0 10px; border-bottom: 1px solid transparent; transition: border-color 0.3s;">PRIVACY POLICY</a>
                                <span style="color: #444444;">|</span>
                                <a href="#" style="color: #666666; text-decoration: none; margin: 0 10px; border-bottom: 1px solid transparent; transition: border-color 0.3s;">TERMS OF SERVICE</a>
                                <span style="color: #444444;">|</span>
                                <a href="#" style="color: #666666; text-decoration: none; margin: 0 10px; border-bottom: 1px solid transparent; transition: border-color 0.3s;">UNSUBSCRIBE</a>
                            </p>
                            
                            <div style="margin-top: 25px; padding-top: 20px; border-top: 1px solid #2a2a2a;">
                                <p style="margin: 0; color: #555555; font-size: 9px; font-family: 'Georgia', serif; letter-spacing: 0.5px;">
                                    This communication is intended solely for the use of the addressee and may contain confidential medical information.
                                </p>
                            </div>
                        </td>
                    </tr>
                    
                </table>
                
            </td>
        </tr>
    </table>
    
</body>
</html>